<?php
header('Content-Type: application/json');

$license_file = '/var/www/html/.securelog_license_cache.dat';

function load_license_cache() {
    global $license_file;
    if (!file_exists($license_file)) {
        return null;
    }
    
    $data = json_decode(file_get_contents($license_file), true);
    return is_array($data) ? $data : null;
}

$license_data = load_license_cache();

if ($license_data) {
    // Verifica se a licença está expirada
    $expiry_date = $license_data['expiry_date'] ?? null;
    $current_time = time();
    
    if ($expiry_date && strtotime($expiry_date) > $current_time) {
        $dias_restantes = ceil((strtotime($expiry_date) - $current_time) / (60 * 60 * 24));
        
        echo json_encode([
            'status' => 'valid',
            'dias_restantes' => $dias_restantes,
            'expiracao' => date('d/m/Y', strtotime($expiry_date)),
            'ip_publico' => $license_data['public_ip'] ?? 'N/A'
        ]);
    } else {
        echo json_encode([
            'status' => 'expired', 
            'dias_restantes' => 0,
            'expiracao' => $expiry_date ? date('d/m/Y', strtotime($expiry_date)) : 'N/A',
            'ip_publico' => $license_data['public_ip'] ?? 'N/A'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'invalid',
        'dias_restantes' => 0,
        'expiracao' => 'N/A',
        'ip_publico' => 'N/A'
    ]);
}
?>
